///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Contains a dynamic cross-list class.
 *	\file		IceXList.h
 *	\author		Pierre Terdiman
 *	\date		December, 12, 1999
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICEXLIST_H__
#define __ICEXLIST_H__

	//! Initial list size
	#define DEFAULT_XLIST_SIZE		2

	class ICECORE_API XList
	{
		public:
		// Constructor / Destructor
										XList();
										~XList();

		// Basic usage
						uword			Add(udword value);
						void			Remove(uword handle);

		// Advanced usage
						bool			Remap(udword* map);

		// Physical data access
		__forceinline	udword			GetMaxNbEntries()	const	{ return mMaxNbEntries;		}	//!< Returns max number of entries		
		__forceinline	udword			GetNbEntries()		const	{ return mCurrentNbEntries;	}	//!< Returns current number of entries		
		__forceinline	udword*			GetList()			const	{ return mList;				}	//!< Gets the complete list
						udword			GetValue(uword handle)		const;							// Returns real value according to handle.
						void*			GetPointer(uword handle)	const;							// Returns real value according to handle.

		//! High-speed access - same as GetValue without any checkings - handle with care.
		__forceinline	udword			PickValue(uword handle)		const	{ return mList[mOutToIn[handle]]; }

						PREVENT_COPY(XList)
		private:
		// Physical list
						udword*			mList;												//!< Physical list, with no holes but unsorted.
						uword			mCurrentNbEntries;									//!< Current number of values in the physical list.
						uword			mMaxNbEntries;										//!< Maximum possible number of values in the physical list.

		// Cross-references
						uword*			mOutToIn;											//!< Maps virtual indices (handles) to real ones.
						uword*			mInToOut;											//!< Maps real indices to virtual ones (handles).

		// Recycled locations
						uword			mNbFreeIndices;										//!< Current number of free indices

		// Internal methods
						XList&			SetupLists(udword* list, uword* oti, uword* ito);
	};

#endif //__ICEXLIST_H__


